/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.collision;

import com.google.gson.JsonElement;
import com.yuushya.block.YuushyaBlockFactory;
import com.yuushya.collision.CollisionFileReader;
import com.yuushya.collision.data.CollisionItem;
import com.yuushya.utils.GsonTools;
import com.yuushya.utils.YuushyaLogger;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class CollisionFileReadReloadListener
extends SimpleJsonResourceReloadListener {
    public static List<String> lazyList;

    public CollisionFileReadReloadListener() {
        super(GsonTools.NormalGSON, "collision");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        YuushyaLogger.info("collisionReader1" + YuushyaBlockFactory.getYuushyaVoxelShapes().size());
        map.forEach((resourceLocation, json) -> {
            CollisionItem collision = (CollisionItem)GsonTools.NormalGSON.fromJson(json, CollisionItem.class);
            CollisionFileReader.getCollisionMap().put(resourceLocation.toString(), collision);
            if (collision.children != null) {
                for (String namespaceId : collision.children) {
                    CollisionFileReader.getCollisionMap().put(namespaceId, collision);
                }
            }
        });
        CollisionFileReader.readAllCollision();
        YuushyaLogger.info("collisionReader2" + YuushyaBlockFactory.getYuushyaVoxelShapes().size());
    }
}

